'==========================================================================
'
' Author......: Raffaele Chiatto
'
' WebSite.....: http://www.raffaelechiatto.com
'
' E-Mail......: raffaele.chiatto@gmail.com
'
'==========================================================================

Option Explicit 

Dim Text, Title, Lnk_Title
Dim WshShell    ' Object variable
Dim status, Ready_txt
Dim Shortcut, DesktopPath

Ready_txt = "Collegamento del Notepad aggiunto con successo sul Desktop"
Text = "Vuoi creare un collegamento del Notepad sul Desktop?"
Title = "Raffaele Chiatto Produced"

' Ask the user whether to create shortcut.
status =  MsgBox(Text, _
                 vbOKCancel + vbInformation, _
                 Title)
If (status <> vbOK) Then
    WScript.Quit 1         ' Cancel selected.
End If

' Create a new WshShell object, which we'll need for 
' the WshSpecialFolders object.
Set WshShell = WScript.CreateObject("WScript.Shell")

' Get path to the Desktop folder using the
' WshSpecialFolders object.
DesktopPath = WshShell.SpecialFolders("Desktop")

' We know the path to the Desktop folder, so we'll use the
' CreateShortcut method to create the shortcut.
Lnk_Title = "\Editor.lnk"
Set Shortcut = WshShell.CreateShortcut(DesktopPath & Lnk_Title)

' Set shortcut properties.
' Target folder
Shortcut.TargetPath = _
    WshShell.ExpandEnvironmentStrings("%WINDIR%\Notepad.exe")

' Working directory
Shortcut.WorkingDirectory = _
    WshShell.ExpandEnvironmentStrings("%WINDIR%")

' Windows style 1 = normal, 3 = maximized, 7 = minimized
Shortcut.WindowStyle = 1  

' Shortcut icon
Shortcut.IconLocation = _
    WshShell.ExpandEnvironmentStrings("%WINDIR%\\Notepad.exe, 0")

Shortcut.Save              ' Create shortcut file.

WScript.Echo Ready_txt     ' Ready message

'*** End

